from database import read

from reddit_scraper.utils import limit_iter
from typing import Iterable, Generic, TypeVar, List


T = TypeVar('T')


class CustomIter(Generic[T]):
    def __init__(self, i: Iterable[T]) -> None:
        self.i = i
        self.l: List[T] = []

    def _iter_leftover(self) -> Iterable[T]:
        for j in self.i:
            self.l.append(j)
            yield j

    def __len__(self):
        list(self._iter_leftover())
        return len(self.l)

    def __iter__(self):
        yield from self.l
        yield from self._iter_leftover()

    @property
    def empty(self) -> bool:
        if len(self.l):
            return False
        
        for _ in self._iter_leftover():
            return False
        
        return True
    
    @property
    def first(self) -> T:
        if self.empty:
            raise KeyError("can't get first element from empty list")
        return self.l[0]

    @property
    def last(self) -> T:
        if self.empty:
            raise KeyError("can't get last element from empty list")
        
        list(self._iter_leftover())
        return self.l[-1]


def test_iter():
    print("yield foo")
    yield "foo"
    print("yield bar")
    yield "bar"
    print("yield baz")
    yield "baz"


if __name__ == "__main__":
    ci: Iterable = CustomIter(test_iter())

    for c in ci:
        print(c)
        break
    
    print("#" * 10)
    for c in ci:
        print(c)