# The amount of days within which to check if the user was reported
LAST_SEEN_THRESHOLD = 180

# The contact name to use in rejection messages
CONTACT = "Admin at admin@example.com"

from urllib.parse import urlencode
from datetime import datetime
import requests

prompt_data = request.context.get("prompt_data")

user_data = {}
if ak_client_ip != ip_address('255.255.255.255'):
  user_data['ip'] = str(ak_client_ip)
if 'email' in prompt_data:
  user_data['email'] = prompt_data['email']
if 'username' in prompt_data:
  user_data['username'] = prompt_data['username']

if len(user_data) == 0:
  ak_logger.warning("Could not find any user data to check against StopForumSpam")
  return True

context['sfs_user_data'] = user_data
resp = requests.get("http://api.stopforumspam.org/api?json&" + urlencode(user_data))

if resp.status_code != 200:
  ak_message(f"There was an error creating your account. Please contact {CONTACT} with the following details: SFS HTTP Error {resp.status_code}")
  ak_logger.warning("StopForumSpam HTTP error", status_code=resp.status_code)
  return False

data = resp.json()
context['sfs_resp_data'] = data

rejected_items = []
def check_passes(name):
  if 'lastseen' in data[name]:
    last_seen = datetime.strptime(data[name]['lastseen'], '%Y-%m-%d %H:%M:%S')
    time_elapsed = datetime.now() - last_seen
    if time_elapsed.days < LAST_SEEN_THRESHOLD:
      rejected_items.append(name)

check_passes('ip')
check_passes('email')
check_passes('username')

if len(rejected_items) > 0:
  context['sfs_rejected_for'] = rejected_items
  ak_message(f"Sorry, we cannot create your account at this time. Please come back later or contact {CONTACT} if the issue persists.")
  return False

return True