# The amount of days within which to check if the user was reported
LAST_SEEN_THRESHOLD = 180
LAST_SEEN_REGEX = r"<lastseen>(\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2})<\/lastseen>"

# The contact name to use in rejection messages
CONTACT = "Admin at admin@example.com"

from datetime import datetime
import requests
import re

prompt_data = request.context.get("prompt_data")

if 'email' in prompt_data:
  user_email = prompt_data['email']
  resp = requests.get(f"http://api.stopforumspam.org/api?email={user_email}")
  
  if resp.status_code != 200:
    ak_message(f"There was an error creating your account. Please contact {contact} with the following details: SFS HTTP Error {resp.status_code}")
    return False

  matches = re.search(LAST_SEEN_REGEX, resp.text)
  if matches is None:
      return True
  
  last_seen = datetime.strptime(matches.group(1), '%Y-%m-%d %H:%M:%S')
  time_elapsed = datetime.now() - last_seen
  if time_elapsed.days < LAST_SEEN_THRESHOLD:
    ak_message(f"Sorry, we cannot approve your account at this time. Please come back later or contact {contact} if the issue persists.")
    return False

return True